// 1106Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "1106.h"
#include "1106Dlg.h"
#include <sys/timeb.h>
#include <time.h>
#include "visa.h"

#pragma comment(lib,"visa32.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMy1106Dlg dialog

CMy1106Dlg::CMy1106Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMy1106Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMy1106Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMy1106Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMy1106Dlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMy1106Dlg, CDialog)
	//{{AFX_MSG_MAP(CMy1106Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTNRANGE, OnBtnrange)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy1106Dlg message handlers

BOOL CMy1106Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMy1106Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMy1106Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMy1106Dlg::OnBtnrange() 
{
	// TODO: Add your control notification handler code here
	OnOK();

}

void CMy1106Dlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	
	ViStatus   status;				/* For checking errors */
	ViSession  defaultRM, instr;	/* Communication channels */
	ViUInt32   retCount;			/* Return count from string I/O */
	char	   *wkbuf;
	unsigned long  devnum = 0;
	unsigned long  findList = 0;
	char       dev_instr[256];
	CString    str1;
	char       chars[10];  

	SetDlgItemText(IDC_ShowBox, _T(""));
	str1 = "";
	/* Begin by initializing the system */
	status = viOpenDefaultRM(&defaultRM);
	if (status < VI_SUCCESS) /* Error Initializing VISA...exiting */
	{
		MessageBox("Open resource manager failed.", "Sample_VC_1", MB_OK);
		return;
	}
	// Find the USBTMC DMM devices  VID:0x164E  PID:0x0DAD
	status = viFindRsrc(defaultRM, "USB[0-9]*::0x164E::0x0DAD::?*INSTR", &findList, &devnum, dev_instr);
	if (status < 0L) 
	{
		viClose(defaultRM);
		str1 = "The DMM device(s) not found.\n";
		SetDlgItemText(IDC_ShowBox, str1);
		return;
	}
	///////////////////////////////////////
	//
	//	List the DMM devices Identification string and instrDesc
	//
	///////////////////////////////////////
	itoa(devnum, chars, 10);
	str1 += "The DMM device(s) found ";
	str1 += chars;
	str1 += "\r\n";
	SetDlgItemText(IDC_ShowBox, str1);		

	if ( devnum > 0 )
	{
		while (1)
		{
			status = viOpen(defaultRM, dev_instr, VI_NULL, VI_NULL, &instr);
			/* Set the timeout for message-based communication */
			status = viSetAttribute(instr, VI_ATTR_TMO_VALUE, 5000);
			/* Allocate space for a path name */
			wkbuf = (char *)malloc( 7 );
			if( !wkbuf )
			{
				MessageBox("Insufficient memory available (viWrite).", "Sample_VC_1", MB_OK);
				status = viClose(instr);
				status = viClose(defaultRM);			
				return;
			}
			strcpy(wkbuf, "*IDN?\n");
			/* Ask the device for identification */
			status = viWrite(instr, (unsigned char *)wkbuf, 6, &retCount);
			free(wkbuf);
			wkbuf = (char *)malloc( 100 );
			if( !wkbuf )
			{
				MessageBox("Insufficient memory available (viRead).", "Sample_VC_1", MB_OK);
				status = viClose(instr);
				status = viClose(defaultRM);
				return;
			}
			Sleep(30);
			status = viRead(instr, (unsigned char *)wkbuf, 100, &retCount);
			wkbuf[retCount] = '\0';
			str1 += "---------------------------------------------------------";
			str1 += "\r\n";
			str1 += wkbuf;
			SetDlgItemText(IDC_ShowBox, str1);
			str1 += "\r\n";
			str1 += dev_instr;
			str1 += "\r\n";
			SetDlgItemText(IDC_ShowBox, str1);

			free(wkbuf);
			wkbuf = (char *)malloc( 14 );
			if( !wkbuf )
			{
				MessageBox("Insufficient memory available (viWrite-system:local).", "Sample_VC_1", MB_OK);
				return;
			}
			strcpy(wkbuf, "system:local\n");
			/* Set device to local mode */
			status = viWrite(instr, (unsigned char *)wkbuf, 13, &retCount);
			free(wkbuf);

			/* Close down the system */
			status = viClose(instr);

			/* find next desriptor */
			status = viFindNext(findList, dev_instr);  
			if (status < 0L) 
			{   /* did we find the next resource? */
				 break;
			}
		}
	}
	status = viClose(defaultRM);	

}

void CMy1106Dlg::OnButton2() 
{
	// TODO: Add your control notification handler code here

	ViStatus   status;				/* For checking errors */
	ViSession  defaultRM, instr;	/* Communication channels */
	ViUInt32   retCount;			/* Return count from string I/O */
	char	   *wkbuf;
	unsigned long  devnum = 0;
	unsigned long  findList = 0;
	char       dev_instr[256];
	CString    str1;
	char       chars[10];  
	int        ss = 500;

	SetDlgItemText(IDC_ShowBox, _T(""));
	str1 = "";
	/* Begin by initializing the system */
	status = viOpenDefaultRM(&defaultRM);
	if (status < VI_SUCCESS) /* Error Initializing VISA...exiting */
	{
		MessageBox("Open resource manager failed.", "Sample_VC_1", MB_OK);
		return;
	}
	// Find the USBTMC DMM devices  VID:0x164E  PID:0x0DAD
	status = viFindRsrc(defaultRM, "USB[0-9]*::0x164E::0x0DAD::?*INSTR", &findList, &devnum, dev_instr);
	if (status < 0L) 
	{
		viClose(defaultRM);
		str1 = "The DMM device(s) not found.\n";
		SetDlgItemText(IDC_ShowBox, str1);
		return;
	}
	///////////////////////////////////////
	//
	//	Set the DMM Configure
	//
	///////////////////////////////////////
	itoa(devnum, chars, 10);
	str1 += "The DMM device(s) found ";
	str1 += chars;
	str1 += "\r\n";
	SetDlgItemText(IDC_ShowBox, str1);

	if ( devnum > 0 )
	{
		while (1)
		{
			status = viOpen(defaultRM, dev_instr, VI_NULL, VI_NULL, &instr);
			/* Set the timeout for message-based communication */
			status = viSetAttribute(instr, VI_ATTR_TMO_VALUE, 5000);
			/* Allocate space for a path name */
			wkbuf = (char *)malloc( 22 );
			if( !wkbuf )
			{
				MessageBox("Insufficient memory available (viWrite).", "Sample_VC_1", MB_OK);
				status = viClose(instr);
				status = viClose(defaultRM);			
				return;
			}

			//  Reference -- configure commands
			//	"CONF:VOLT:DC"     // Set DMM CONF:VOLTage:DC
			//	"CONF:VOLT:AC"     // Set DMM CONF:VOLTage:AC
			//	"CONF:CURR:DC"     // Set DMM CONF:CURRent:DC
			//	"CONF:CURR:AC"     // Set DMM CONF:CURRent:DC
			//	"CONF:RES"         // Set DMM CONF:RESistance
			//	"CONF:FRES"        // Set DMM CONF:FRESistance
			//	"CONF:FREQ"        // Set DMM CONF:FREQuency
			//	"CONF:PER"         // Set DMM CONF:Period
			strcpy(wkbuf, "CONF:VOLT:DC\n");            // Set DMM CONF:VOLTage:DC
			status = viWrite(instr, (unsigned char *)wkbuf, 13, &retCount);
			Sleep(ss);
			strcpy(wkbuf, "TRIG:DELAY 0\n");            // Set DMM Trigger Delay 0
			status = viWrite(instr, (unsigned char *)wkbuf, 13, &retCount);
			Sleep(ss);
			strcpy(wkbuf, "SENS:ZERO:AUTO OFF\n");      // Set DMM Auto Zero off
			status = viWrite(instr, (unsigned char *)wkbuf, 19, &retCount);
			Sleep(ss);
			strcpy(wkbuf, "SENS:GAIN:AUTO OFF\n");      // Set DMM Auto Gain off
			status = viWrite(instr, (unsigned char *)wkbuf, 19, &retCount);
			Sleep(ss);
			strcpy(wkbuf, "SENS:VOLT:DC:RANGE 1\n");    // Set DMM Voltage Range 1
			status = viWrite(instr, (unsigned char *)wkbuf, 21, &retCount);
			Sleep(ss);
			free(wkbuf);

			str1 += "---------------------------------------------------------";
			str1 += "\r\n";
			str1 += dev_instr;
			str1 += "\r\n";
			SetDlgItemText(IDC_ShowBox, str1);

			free(wkbuf);
			wkbuf = (char *)malloc( 14 );
			if( !wkbuf )
			{
				MessageBox("Insufficient memory available (viWrite-system:local).", "Sample_VC_1", MB_OK);
				return;
			}
			strcpy(wkbuf, "system:local\n");
			/* Set device to local mode */
			status = viWrite(instr, (unsigned char *)wkbuf, 13, &retCount);
			free(wkbuf);

			/* Close down the system */
			status = viClose(instr);

			/* find next desriptor */
			status = viFindNext(findList, dev_instr);  
			if (status < 0L) 
			{   /* did we find the next resource? */
				 break;
			}
		}
	}
	status = viClose(defaultRM);

}

void CMy1106Dlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
	ViStatus   status;				/* For checking errors */
	ViSession  defaultRM, instr;	/* Communication channels */
	ViUInt32   retCount;			/* Return count from string I/O */
	char	   *wkbuf;
	char       *wkinbuf;
	unsigned long  devnum = 0;
	unsigned long  findList = 0;
	char       dev_instr[256];
	CString    str1;
	char       chars[10];  
	int        ss = 50;
	int        j;

	SetDlgItemText(IDC_ShowBox, _T(""));
	str1 = "";
	/* Begin by initializing the system */
	status = viOpenDefaultRM(&defaultRM);
	if (status < VI_SUCCESS) /* Error Initializing VISA...exiting */
	{
		MessageBox("Open resource manager failed.", "Sample_VC_1", MB_OK);
		return;
	}
	// Find the USBTMC DMM devices  VID:0x164E  PID:0x0DAD
	status = viFindRsrc(defaultRM, "USB[0-9]*::0x164E::0x0DAD::?*INSTR", &findList, &devnum, dev_instr);
	if (status < 0L) 
	{
		viClose(defaultRM);
		str1 = "The DMM device(s) not found.\n";
		SetDlgItemText(IDC_ShowBox, str1);
		return;
	}
	///////////////////////////////////////
	//
	//	List the DMM devices Identification string and instrDesc
	//
	///////////////////////////////////////
	itoa(devnum, chars, 10);
	str1 += "The DMM device(s) found ";
	str1 += chars;
	str1 += "\r\n";
	SetDlgItemText(IDC_ShowBox, str1);		

	if ( devnum > 0 )
	{
		while (1)
		{
			status = viOpen(defaultRM, dev_instr, VI_NULL, VI_NULL, &instr);
			/* Set the timeout for message-based communication */
			status = viSetAttribute(instr, VI_ATTR_TMO_VALUE, 7000);
			/* Show the instrument description */
			str1 += "---------------------------------------------------------";
			str1 += "\r\n";
			str1 += dev_instr;
			str1 += "\r\n";
			SetDlgItemText(IDC_ShowBox, str1);
			wkbuf = (char *)malloc( 28 );
			if( !wkbuf )
			{
				MessageBox("Insufficient memory available (viWrite).", "Sample_VC_1", MB_OK);
				status = viClose(instr);
				status = viClose(defaultRM);			
				return;
			}

			strcpy(wkbuf, "CONF:VOLT:DC\n");
			status = viWrite(instr, (unsigned char *)wkbuf, 13, &retCount);
			Sleep(ss);
			strcpy(wkbuf, "SENS:VOLT:DC:RANGE:AUTO ON\n");
			status = viWrite(instr, (unsigned char *)wkbuf, 27, &retCount);
			Sleep(ss);
			wkinbuf = (char *)malloc( 64 );
			if( !wkinbuf )
			{
				MessageBox("Insufficient memory available (viRead).", "Sample_VC_1", MB_OK);
				status = viClose(instr);
				status = viClose(defaultRM);
				return;
			}
			strcpy(wkbuf, "read?\n");

			for (j=0; j<10; j++)
			{
				// send the 'read?' command 
				status = viWrite(instr, (unsigned char *)wkbuf, 6, &retCount);
				Sleep(ss);
				ZeroMemory(wkinbuf, 64);
				// read-in the DMM data
				status = viRead(instr, (unsigned char *)wkinbuf, 64, &retCount);
				wkinbuf[retCount] = '\0';
				str1 += wkinbuf;
				str1 += "\r\n";
				SetDlgItemText(IDC_ShowBox, str1);
			}
			free(wkinbuf);
			free(wkbuf);
			wkbuf = (char *)malloc( 14 );
			if( !wkbuf )
			{
				MessageBox("Insufficient memory available (viWrite-system:local).", "Sample_VC_1", MB_OK);
				return;
			}
			strcpy(wkbuf, "system:local\n");
			/* Set device to local mode */
			status = viWrite(instr, (unsigned char *)wkbuf, 13, &retCount);
			free(wkbuf);

			/* Close down the system */
			status = viClose(instr);

			/* find next desriptor */
			status = viFindNext(findList, dev_instr);  
			if (status < 0L) 
			{   /* did we find the next resource? */
				 break;
			}
		}
	}
	status = viClose(defaultRM);

}
